#version 430 core

layout(location = 0) in vec3 aPos;
layout(location = 1) in vec3 aNormal;

uniform mat4 view;
uniform mat4 projection;

struct Instance {
    vec4 pos_scale; // xyz = center, w = size
};

layout(std430, binding = 0) buffer Instances {
    Instance instances[];
};

out vec3 vPos;
out vec3 vNormal;

void main() {
    Instance inst = instances[gl_InstanceID];

    vec3 scaledPos = aPos * inst.pos_scale.w + inst.pos_scale.xyz*1.0;

    vec4 worldPos = vec4(scaledPos, 1.0);
    vPos = worldPos.xyz;
    vNormal = normalize(aNormal); 

    gl_Position = projection * view * worldPos;
}
